oldPlayState = 0;
function EcouteSel(el) { return document.getElementById(el); }

function artworkUpdate(artURL)
{
	if (!artURL)
		EcouteSel('coverImg').src = "images/nocover.png";
	else
		EcouteSel('coverImg').src = artURL;
}

function playerUpdate()
{
	var pState = Ecoute.playState();

	if (pState != oldPlayState)
	{
		if (pState == 0 || pState == 2)
			EcouteSel('playLink').innerHTML = '<img src="images/play.png">';
		else
			EcouteSel('playLink').innerHTML = '<img src="images/pause.png">';
		
		oldPlayState = pState;
	}
}

function trackUpdate(track)
{
	var name = track.property('title');
	var artist = track.property('artist');
	var album = track.property('album');
	
	EcouteSel('songname').innerHTML = name;
	EcouteSel('artist').innerHTML = artist;
	EcouteSel('album').innerHTML = album;
}

function playPause()
{
	Ecoute.playPause();
}

mouseDown = false;
	mouseX = 0;
	mouseY = 0;
	
	mouseStartX = 0;
	mouseStartY = 0;
	startFrame = [];
	document.onmousedown = function(e)
	{
		mouseDown = true;
		
		mouseStartX = e.screenX;
		mouseStartY = e.screenY;
		startFrame = Ecoute.frame();
	}
	document.onmouseup = function()
	{
		mouseDown = false;
	}
	document.onmousemove = function(e)
	{
		mouseX = e.screenX;
		mouseY = e.screenY;
		
		if (mouseDown)
		{
			deltaX = mouseX - mouseStartX;
			deltaY = mouseStartY - mouseY;	// flipped coordinate system
			
			Ecoute.setFrame(startFrame[0]+deltaX, startFrame[1]+deltaY, startFrame[2], startFrame[3]);
		}
	}